/*
 * Copyright (C) 2012 Edge-Core Networks
 * This software file (the "File") is owned and distributed by 
 * Edge-Core Networks under the following licensing terms.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include "ams_lib.h"

static int global_log_level = 4;

int vsprintf(char *buf, const char *fmt, va_list args);

static int vprintk(const char *fmt, va_list args)
{
    int printed_len, log_level;
    char *p;
    static char printk_buf[4096];


    /* Emit the output into the temporary buffer */
    printed_len = vsprintf(printk_buf, fmt, args);

    if (printed_len > 0)
    {
        p = printk_buf;
        
        if (printed_len > 0 && p[0] == '<' && p[1] >= '0'
            && p[1] <= '9' && p[2] == '>')
        {
            log_level = (p[1] - '0') & ((int)0 - 1);
            p = &p[3];
            printed_len -= 3;

        }
        else 
        {
            log_level = DEFAULT_LOG_LEVEL;
        }

        if ((log_level <= global_log_level) && (printed_len > 0))
        {
            puts(p);
            return printed_len;
        }
    }
    return 0;
}

int ams_printk(const char *fmt, ...)
{
    va_list args;
    int r;

    va_start(args, fmt);
    r = vprintk(fmt, args);
    va_end(args);

    return r;
}
/*-------------------------------------------------------------------------
 * FUNCTION NAME - CheckSum
 * ------------------------------------------------------------------------
 * PURPOSE  :   This funtion will caculate the checksum of the data
 * INPUT    :       start_addr - start address of the buffer
 *                  length        - the length of the data
 * OUTPUT   :   None
 * RETURN   :   The checksum of the data
 * NOTES    :   None
 * ------------------------------------------------------------------------
 */
unsigned long CheckSum(unsigned long start_addr, unsigned long length)
{
	unsigned long checksum, mask;
	unsigned long i;
	
	checksum = 0; 
	
	/* loop 32-bit a time */
	for (i = 0; i < length; i += 4)
	{
		if (i+4 > length)
			mask = 0xffffffff << ((i+4-length)<<3);
		else
			mask = 0xffffffff;

		checksum ^= (*(unsigned long*)(start_addr+i) & mask);
	}
	
	return checksum;
}


